from cbml_benchmark.modeling.registry import BACKBONES

from .bninception import BNInception
from .resnet import ResNet18, ResNet34, ResNet50, ResNet101, ResNet152
from .googlenet import GoogLeNet
from .mix_transformer import mit_b0,mit_b1,mit_b2,mit_b3,mit_b4,mit_b5
from .deit import deit_tiny_patch16_224,deit_tiny_distilled_patch16_224,deit_small_patch16_224,deit_small_distilled_patch16_224,deit_base_distilled_patch16_224,deit_base_distilled_patch16_384,deit_base_patch16_224,deit_base_patch16_384


def build_backbone(cfg):
    assert cfg.MODEL.BACKBONE.NAME in BACKBONES, \
        f"backbone {cfg.MODEL.BACKBONE} is not registered in registry : {BACKBONES.keys()}"
    return BACKBONES[cfg.MODEL.BACKBONE.NAME]()
